/* **********************************************************
Name:                           Chiao Cheng
Student ID:             102-571-144
Login ID:               chiaoc
e-mail                  chiaoc@ucla.edu
Discussion:             2C; TuTh 12:00pm - 12:50pm
TA:                             Clement Chang

                ===========================
        Assignment 1: Objects
      ===========================

Honesty Pledge:

        I, Chiao Cheng, pledge that this is my own independent
   work, which conforms to the guidelines of academic
   honesty as described in the course syllabus.


   List of Known Bugs in my Solution:    None.
   ----------------------------------

*/
// ***********************************************************

#include<fstream.h>
#include<iomanip.h>
#include<assert.h>
#include<stddef.h>

const MAX_SET_SIZE = 97;

//------------------------------------------------------------------------------
//              Begin Class Declaration
//------------------------------------------------------------------------------

class Set
{
        private:
                int size;
      char* elements;
   public:
                Set();
      Set(char* string);
      Set(const Set&);
      ~Set();
      bool has(char) const;
      Set Set::operator&( const Set&) const;
      Set Set::operator+( const Set&) const;
      Set Set::operator-( const Set&) const;
      Set Set::operator=( const Set&) const;
      friend istream& operator>>(istream&, Set&);
      friend ostream& operator<<(ostream&, const Set&);
};

//------------------------------------------------------------------------------
//              End Class Declaration
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//              Begin Class Implementation
//------------------------------------------------------------------------------

//--------- BEGIN: Default Constructor -------
Set::Set()
{
        size = 0;
   elements = NULL;
}
//--------- END: Default Constructor ---------

//--------- BEGIN: Char String Constructor ---
Set::Set(char* string)
{
        // Precondition:    string is a null terminated array.
   // Postcondition:   A Set is created and the array is stored in the
new set.

        size = strlen(string);
   elements = new char[size+1];
   assert (elements);
   strcpy (elements, string);
}
//---------- END: Char String Constructor ----

//---------- BEGIN: Copy Constructor ---------
Set::Set(const Set& S)
{
        size = S.size;
   elements = new char [size];
   assert (elements);
   for (int i=0; i < size; i++)
                elements[i] = S.elements[i];
}
//---------- END: Copy Constructor -----------

//---------- BEGIN: Destructor ---------------
Set::~Set()
{
        if (elements)
        delete [] elements;
}
//---------- END: Destructor -----------------

//---------- BEGIN: has member function ------
bool Set::has(char character) const
{
        // Precondition:    character is a printable ASCII character.
   // Postcondition:   Returns true if the character is found in the
calling
   //            object.  If not, then false is returned.

        bool test = false;
   int i=0;
   while (i < size)
                if (elements[i++] == character)
      {
        test = true;
         return test;
        }
   return test;
}
//----------- END: has member function -------

// ---------- BEGIN Intersection Operator -----------------------
Set Set::operator&( const Set& S)  const // Intersection
{
   // Precondition:    S is a Set object
   // Postcondition:   An output object equal to the intersection
   //            of S and the calling object is created and
   //            returned.

   int maxlength = ( size < S.size ? size : S.size );
   char* temp;
   if ( maxlength )                  // Nonempty Intersection
   {
      temp = new char[ maxlength+1 ]; // Allocate.
      assert( temp );                // Confirm success

      int i, j=0;
      for( i = 0; i < size; ++i )
         if ( S.has(elements[i]) )
             temp[j++] = elements[i];

      temp[j] = '\0';
      Set Intersection( temp );
      delete [] temp;             // Deallocate.
      return Intersection;
   }
   else
   {
      Set Intersection;         // Intersection is empty.
      return Intersection;
   }

}
// ---------- END Intersection Operator -----------------------

//----------- BEGIN: Union Operator --------------------
Set Set::operator+(const Set& S) const
{
   // Precondition:    S is a Set object
   // Postcondition:   An output object equal to the union
   //            of S and the calling object is created and
   //            returned.

        int max = size + S.size;
   if(max)
   {
      int j=0;
        char *temp = new char[max+1];
      assert(temp);
      for (int i=0; i < size; i++)
        temp[i]=elements[i];
      for (int i=0; i < S.size; i++)
        if (!(has(S.elements[i])))
         {
                temp[j+size] = S.elements[i];
            j++;
                }
        temp[j+size] = '\0';
      Set sum(temp);
      delete [] temp;
      return sum;
   }
        else
   {
        Set sum;
      return sum;
   }
}
//----------- END: Union Operator ------------

//----------- BEGIN: Difference Operator -----
Set Set::operator-(const Set& S) const
{
   // Precondition:    S is a Set object
   // Postcondition:   An output object equal to the Difference
   //            of S and the calling object is created and
   //            returned.

   int max = size, i, j=0;
   char *temp = new char[max+1];
   if (S.size)
   {
                for (i=0; i < size; i++)
        if (!(S.has(elements[i])))
                temp[j++] = elements[i];
   }
        else
        for (i=0; i < size; i++)
        temp[j++] = elements[i];
   temp[j] = '\0';
   Set difference(temp);
   delete [] temp;
        return difference;
}
//----------- END: Difference Operator -------

//------------------------------------------------------------------------------
//              End Class Implementation
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//              Begin Friends of class Set{}
//------------------------------------------------------------------------------

//------------- BEGIN: Set input operator ----------------
istream& operator>>( istream& Input, Set& S )
{
  // Precondition:    S is a Set object, Input is an input stream
  // Postcondition:   S has been overwritten by the user's input,
  //                    which is checked for validity and redundancy.

  //  To enable this operator for class Set{}, you must declare it
  //    as a "friend" in the definition of class Set{}.

   const int MIN_CHAR =  31;   // ASCII value of least printable char
   const int MAX_CHAR = 127;   // ASCII value of greatest printable char

   char symbol, temp[ MAX_SET_SIZE ];
   temp[0] = '\0';           // temp[] will store a string
   int length = 0;

   do
   {
      Input.get(symbol);
      // Check validity:
      if ( symbol != ' ' && symbol > MIN_CHAR && symbol < MAX_CHAR )
      {
          bool distinct = true;                 // Check redundancy.
          int j = 0;
          while (distinct && temp[j])
          {
             distinct = ( symbol != temp[j] );
             j++;
          }

          if (distinct)
          {
             temp[j]    = symbol;
             temp[j+1]  = '\0';
             length++;
          }
      }
   }
   while (symbol > 31 );

   if (symbol != '\n')
     Input.get(symbol);     // Remove the trailing newline if necessary

   S.size = length;
   delete [] S.elements;       // Return old memory before requesting
new memory
   S.elements  = new char[length];
   assert ( S.elements );      // Confirm success of memory grab

   for (int j = 0; j < length; j++ )
      S.elements[j] = temp[j];

   return Input;
}
//------------- END: Set input operator ----------------

//------------- BEGIN: Set ouput operator --------------
ostream& operator<<(ostream& output, const Set& S)
{
   // Precondition:    S is a Set object, Input is an input stream
   // Postcondition:   S has been ouputed to the the corresponding
   //                    ostream object.

   //  To enable this operator for class Set{}, you must declare it
   //    as a "friend" in the definition of class Set{}.

   for (int i=0; i < S.size; i++)     //outputs item by item.
        output << S.elements[i];
   return output;
}
//------------- END: Set ouput operator ----------------

//------------------------------------------------------------------------------
//              End Friends of class Set{}
//------------------------------------------------------------------------------


//------------------------------------------------------------------------------
//              Begin main()  function
//------------------------------------------------------------------------------

void main(void)
{
   cout << "\n                  ==============\n"
          << "                  Set Calculator\n"
        << "                    ==============\n\n";
   cout << "A Set is a collection of nonspace, printable keyboard
characters.\n"
                << "To enter a Set, type its elements one by one on a single
line.\n"
         << "Spaces are ignored.\n\n";
   Set a;
   Set b;
   cout << "Enter Set A:  \n";
   cin >> a;
   cout << "\nEnter Set B:  \n";
   cin >> b;
   cout << endl << "A =     { " << a << " }\n\n";
   cout << "B =     { " << b << " }\n\n";
   cout << "A & B =     { " << (a & b) << " }\n\n";
   cout << "A + B =     { " << (a + b) << " }\n\n";
        cout << "A - B =     { " << (a - b) << " }\n\n";
        cout << "B - A =     { " << (b - a) << " }\n\n";
        cout << "Press <Enter> to Quit.";
   char letter;
   cin.get(letter);
}
//--------------------------------------------
//              End main()  function
//--------------------------------------------